/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.serviceaction.repair.effectors.selectfrus;

import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.ThreeButtonGroupContainer;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.service.statetransition.Effector;
import com.ibm.hwmca.fw.service.statetransition.EffectorException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.panel.PBCommonQueryFRUAvailable;
import com.ibm.hwmca.xfw.service.panel.PBCommonQueryFRUGroupAvailable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CheckSelectedFrusAvailable
implements Effector {
    private static final String TRACE_MASKT = "XRVXFAVT";
    private static final String TRACE_MASKF = "XRVXFAVF";
    private static final String TRACE_MASKD = "XRVXFAVD";
    private GenericGui guiHandle;

    public void fire(Context context) throws EffectorException {
        Trace.trace(TRACE_MASKT, "-> CheckSelectedFrusAvailable.fire");
        try {
            Map userData = context.getUserData();
            this.guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            List selectedFrus = (List)userData.get("SELECTED_FRUS");
            HashMap<String, String> guiMap = new HashMap<String, String>();
            if (selectedFrus != null) {
                CommonDataBean bean;
                Iterator it = selectedFrus.iterator();
                Vector allRows = new Vector();
                while (it.hasNext()) {
                    Fru fru = (Fru)it.next();
                    Map fruProps = fru.getProperties();
                    Vector<String> singleRow = new Vector<String>();
                    String location = (String)fruProps.get("LOCATION");
                    location = location == null ? "" : location;
                    guiMap.put("location", location);
                    singleRow.add(location);
                    String desc = (String)fruProps.get("DESC");
                    desc = desc == null ? "" : desc;
                    guiMap.put("description", desc);
                    singleRow.add(desc);
                    allRows.add(singleRow);
                }
                if (allRows.size() == 1) {
                    bean = new PBCommonQueryFRUAvailable();
                    bean.setDataMap(guiMap);
                } else {
                    bean = new PBCommonQueryFRUGroupAvailable(allRows);
                }
                bean = (CommonDataBean)this.guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ((CommonDataBean)bean).getTemplateName(), bean, userData);
                String selection = ((ThreeButtonGroupContainer)((Object)bean)).getButtongroupSelection()[0];
                if (selection.equals("RadioButton1")) {
                    context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.AVAILABLE);
                } else if (selection.equals("RadioButton2")) {
                    context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.NOT_AVAILABLE);
                }
            } else {
                Trace.trace(TRACE_MASKT, "CheckSelectedFrusAvailable.fire No FRUs were selected?");
                context.getVariable(SD.FRU_SELECTION_STATUS_VARIABLE).setValue(SD.NONE_SELECTED);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! CheckSelectedFrusAvailable.fire Exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new EffectorException(e);
        }
        Trace.trace(TRACE_MASKT, "<- CheckSelectedFrusAvailable.fire");
    }
}

